local t = Def.ActorFrame{};
local function IsW5Disabled() if PREFSMAN:GetPreference("TimingWindowSecondsW5") == 0 then return true else return false end end
local StagesPlayed = STATSMAN:GetStagesPlayed()
local ratemod = MetroQuad.Global.PlayedRateMods

local function GetPlayedSongTitles(i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local PlayedSongs = pSS:GetPlayedSongs()
	local Song = PlayedSongs[1]:GetDisplayFullTitle()
	return Song
end

local function GetPlayedSongBanner(i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local PlayedSongs = pSS:GetPlayedSongs()
	local Song = PlayedSongs[1]:GetBannerPath()
	return Song
end

local function GetPlayedJudgment(pn,i,tns)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local TNS = plSS:GetTapNoteScores(tns)
	return TNS
end

local function DisplayBPM(i)
	local playedSong, bpm = STATSMAN:GetPlayedStageStats(i):GetPlayedSongs()
	local bpm = playedSong[1]:GetDisplayBpms()
	local display
	
	if tonumber(ratemod[i]) ~= 1 then	
		if bpm[1] == bpm[2] then
			display = round(bpm[1] * ratemod[i]).." (RATE "..ratemod[i]..")"
		else
			display = round(bpm[1] * ratemod[i]).." - "..round(bpm[2] * ratemod[i]).." (RATE "..ratemod[i]..")"
		end
	else
		if bpm[1] == bpm[2] then
			display = round(bpm[1])
		else
			display = round(bpm[1]).." - "..round(bpm[2])
		end
	end

	return "BPM "..display
end

local function GetDifficultyColor(pn,i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local pSteps = plSS:GetPlayedSteps()
	local Step = pSteps[1]
	
	if Step == nil then
		return 'Difficulty_Edit'
	else
		Step = pSteps[1]
	end
	
	local Diff = Step:GetDifficulty()
	return Diff
end

local function GetColorForPassOrFail(pn,i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local Grade = plSS:GetGrade()
	
	if Grade == nil then Grade = "N/A" else Grade = plSS:GetGrade() end
	
	if Grade == 'Grade_Failed' then return Red() else return White() end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(draworder,-1);
	Def.Quad{InitCommand=cmd(x,CenterX();y,Top()+40;valign,0;zoomto,Width(),22;diffuse,Black();zwrite,true;blend,'BlendMode_NoEffect');};
};

for i=1,StagesPlayed do
	local AbleToMoveDown = StagesPlayed - 5
	local AbleToMoveUp = 0
	t[#t+1] = Def.ActorFrame{
		BeginCommand=cmd(zwrite,true;ztest,true);
		CodeMessageCommand=function(self,param)
			if param.Name == "Up" then
				if AbleToMoveUp > 0 then
					self:addy(76)
					AbleToMoveUp = AbleToMoveUp - 1
					AbleToMoveDown = AbleToMoveDown + 1
				end
			end
			if param.Name == "Down" then
				if AbleToMoveDown > 0 then
					self:addy(-76)
					AbleToMoveDown = AbleToMoveDown - 1
					AbleToMoveUp = AbleToMoveUp + 1
				end
			end
		end;
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX();y,Top()-10+(76*i);valign,0;zoom,0.4;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(GetPlayedSongTitles(i))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX();y,Top()+44+(76*i);valign,0;zoom,0.35;shadowlength,1;maxwidth,500;uppercase,true;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3);playcommand,"Song");
			SongCommand=function(self)
				self:settext(DisplayBPM(i))
			end
		};
		Def.Quad{ -- #1
			InitCommand=cmd(draworder,-501;x,CenterX();y,Top()-14+(76*i);valign,0;zoomto,210,16;diffuse,Black();diffusealpha,0.5);
		};
		Def.Quad{ -- #1
			InitCommand=cmd(draworder,-501;x,CenterX();y,Top()+42+(76*i);valign,0;zoomto,210,12;diffuse,Black();diffusealpha,0.5);
		};
		Def.Quad{ -- #1
			InitCommand=cmd(draworder,-1000;x,CenterX();y,Top()-14+(76*i);valign,0;zoomto,Width()-16,68;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2);diffusealpha,0.2);
		};
		Def.Sprite{
			InitCommand=cmd(draworder,-800;x,CenterX();y,Top()-14+(76*i);valign,0;scaletoclipped,210,68;playcommand,"Banner");
			BannerCommand=function(self)
				self:Load(GetPlayedSongBanner(i))
			end;
		};
		
		-- PLAYER 1
		Def.Quad{
			BeginCommand=cmd(xy,Left()+8,Top()+14+(76*i);setsize,182,32;zoomx,0.99;zoomy,1.24;align,0,0;faderight,0.1;visible,IsPlayerEnabled(PLAYER_1));
			InitCommand=function(self) self:diffusetopedge(Black()):diffusebottomedge(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)) end;
		};
		Def.GraphDisplay{
			InitCommand=cmd(xy,Left()+8,Top()+34+(76*i);zoomx,0.7;zoomy,0.62;align,0,0;visible,IsPlayerEnabled(PLAYER_1));
			OnCommand=function(self)
				self:Load("GraphDisplay")
				local playerStageStats = STATSMAN:GetPlayedStageStats(i):GetPlayerStageStats(PLAYER_1)
				local stageStats = STATSMAN:GetPlayedStageStats(i)
				self:Set(stageStats, playerStageStats)
				self:GetChild("Line"):ztest(true)
			end;
		};
		LoadFont("Common Normal")..{
			Name="Grade";
			InitCommand=cmd(x,Left()+48;y,Top()-10+(76*i);align,0,0;zoom,0.5;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(GetPlayedGrade(PLAYER_1,i)):visible(IsPlayerEnabled(PLAYER_1)):diffuse(GetColorForPassOrFail(PLAYER_1,i))
			end
		};
		LoadFont("_PercentScore")..{
			Name="Score";
			InitCommand=cmd(xy,CenterX()-110-48,Top()+20+(76*i);align,1,0;shadowlength,2;zoom,0.5;maxwidth,500;uppercase,true);
			OnCommand=function(self) self:settext(FormatPercentScore(GetPlayedScore(PLAYER_1,i)):gsub("%%","")):visible(IsPlayerEnabled(PLAYER_1)):diffuse(GetColorForPassOrFail(PLAYER_1,i)) end
		};
		Def.Quad{
			BeginCommand=cmd(x,Left()+8;y,Top()-14+(76*i);setsize,32,20;align,0,0);
			InitCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_1,i))):visible(IsPlayerEnabled(PLAYER_1))
			end,
		};
		LoadFont("Common Normal")..{
			Name="Difficulty Meter P1";
			InitCommand=cmd(x,Left()+12;y,Top()-10+(76*i);align,0,0;zoom,0.5;diffuse,Black());
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_1) then self:settext(round(GetPlayedMeter(PLAYER_1,i) * ratemod[i])) else self:visible(false) end end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-110;y,Top()-10+(76*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[1]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,9)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,9); Diffuse = ColorDarkTone(color(jColors[1])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-110;y,Top()-10+16+(76*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[2]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,8)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,8); Diffuse = ColorDarkTone(color(jColors[2])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-110;y,Top()-10+16*2+(76*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[3]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,7)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,7); Diffuse = ColorDarkTone(color(jColors[3])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-110;y,Top()-10+16*3+(76*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[4]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,6)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,6); Diffuse = ColorDarkTone(color(jColors[4])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-110-50;y,Top()-10+(76*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[5]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,5)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,5); Diffuse = ColorDarkTone(color(jColors[5])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-110-50;y,Top()-10+16+(76*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[6]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,4)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,4); Diffuse = ColorDarkTone(color(jColors[6])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		
		-- PLAYER 2
		Def.Quad{
			BeginCommand=cmd(xy,Right()-8,Top()+14+(76*i);setsize,182,32;zoomx,0.99;zoomy,1.24;align,1,0;fadeleft,0.1;visible,IsPlayerEnabled(PLAYER_2));
			InitCommand=function(self) self:diffusetopedge(Black()):diffusebottomedge(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)) end;
		};
		Def.GraphDisplay{
			InitCommand=cmd(xy,Right()-8,Top()+34+(76*i);zoomx,0.7;zoomy,0.62;align,1,0;visible,IsPlayerEnabled(PLAYER_2));
			OnCommand=function(self)
				self:Load("GraphDisplay")
				local playerStageStats = STATSMAN:GetPlayedStageStats(i):GetPlayerStageStats(PLAYER_2)
				local stageStats = STATSMAN:GetPlayedStageStats(i)
				self:Set(stageStats, playerStageStats)
				self:GetChild("Line"):ztest(true)
			end;
		};
		LoadFont("Common Normal")..{
			Name="Grade";
			InitCommand=cmd(x,Right()-48;y,Top()-10+(76*i);align,1,0;zoom,0.5;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self) self:settext(GetPlayedGrade(PLAYER_2,i)):visible(IsPlayerEnabled(PLAYER_2)):diffuse(GetColorForPassOrFail(PLAYER_2,i)) end
		};
		LoadFont("_PercentScore")..{
			Name="Score";
			InitCommand=cmd(xy,CenterX()+110+48,Top()+20+(76*i);align,0,0;shadowlength,2;zoom,0.5;maxwidth,500;uppercase,true);
			OnCommand=function(self) self:settext(FormatPercentScore(GetPlayedScore(PLAYER_2,i)):gsub("%%",""):gsub(" ","")):visible(IsPlayerEnabled(PLAYER_2)):diffuse(GetColorForPassOrFail(PLAYER_2,i)) end
		};
		Def.Quad{
			BeginCommand=cmd(x,Right()-8;y,Top()-14+(76*i);setsize,32,20;align,1,0);
			InitCommand=function(self) self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_2,i))):visible(IsPlayerEnabled(PLAYER_2)) end
		};
		LoadFont("Common Normal")..{
			Name="Difficulty Meter P2";
			InitCommand=cmd(x,Right()-12;y,Top()-10+(76*i);align,1,0;zoom,0.5;diffuse,Black());
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext(round(GetPlayedMeter(PLAYER_2,i) or 0 * ratemod[i])) else self:visible(false) end end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+110;y,Top()-10+(76*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[1]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,9)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,9); Diffuse = ColorDarkTone(color(jColors[1])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+110;y,Top()-10+16+(76*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[2]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,8)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,8); Diffuse = ColorDarkTone(color(jColors[2])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+110;y,Top()-10+16*2+(76*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[3]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,7)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,7); Diffuse = ColorDarkTone(color(jColors[3])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+110;y,Top()-10+16*3+(76*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[4]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,6)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,6); Diffuse = ColorDarkTone(color(jColors[4])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+110+50;y,Top()-10+(76*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[5]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,5)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,5); Diffuse = ColorDarkTone(color(jColors[5])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+110+50;y,Top()-10+16+(76*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;diffuse,color(jColors[6]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,4)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,4); Diffuse = ColorDarkTone(color(jColors[6])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
	};
end

t[#t+1] = Def.ActorFrame{
	Def.Quad {
		InitCommand=cmd(xy,CenterX(),Bottom();valign,1;setsize,Width(),16;diffuse,Black());
	};
	Def.Quad {
		InitCommand=cmd(draworder,-1;x,CenterX();y,Bottom();valign,1;zoomto,Width(),40;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));
	};
};

return t